<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Validator;
use Hash;

class AdminController extends Controller
{
    function admin(){
		$title ="Admin";
		
		$data = DB::table("users")->get();
		
		return view('konfigurasi/admin/index', compact('data','title'));
	}
	
		
	function admin_add(){
		$title  = "Tambah Data Admin";
		return view('konfigurasi/admin/add', compact('title'));
		
	}
	function admin_simpan(Request $r){
		 $validator = Validator::make($r->all(), [
            'name' => 'required|max:255',
			'username' => 'required|max:255',
			'email' => 'required|max:255',
        ]);
		
		if ($validator->fails()) {
            return redirect('konfigurasi/admin/add')
                        ->withErrors($validator)
                        ->withInput();
        }
		$cek = $this->cekuser($r->userid,$r->email);
		
		if($cek > 0){
			return redirect('konfigurasi/admin/add')->with(['warning'=>'ID User / email sudah digunakan!'])->withInput();
		}
		
		
		DB::table('users')->insert([
			'fullname' => $r->name,
			'username' => $r->username,
			'email' => $r->email,
			'akses' => $r->akses,
			'password' =>  Hash::make('1234'),
			]);
			
		return redirect('konfigurasi/admin')->with('success','Data berhasil disimpan');
	}
	
	
	private function cekuser($userid,$email){
		$rs = DB::table("users")
		->where("username",$userid)
		->orWhere("email",$email)
		->count();
		
		return $rs;
	}
	
	function admin_edit($id){
		$title  = "Edit Data Admin";
		
		$data = DB::table("users")->where("id",$id)->first();
		return view('konfigurasi/admin/edit', compact('data','title'));
		
	}
	
	function admin_update(Request $r){
		$validator = Validator::make($r->all(), [
            'username' => 'required|max:255',
        ]);
		if ($validator->fails()) {
            return redirect('konfigurasi/admin/add')
                        ->withErrors($validator)
                        ->withInput();
        }
		DB::table('admin')
		->where("id",$r->id_paket)
		->update([
			'username' => $r->username,
			]);
			
		return redirect('konfigurasi/admin')->with(['success' => 'Data berhasil disimpan']);;
	}

	function sitelist(Request $r){
		$user = $r->userid;
		$rs = DB::table("users_sites")
		->leftJoin("users","users.email","=","users_sites.userid")
		->leftJoin("master_site","users_sites.siteid","=","master_site.siteid")
		->select("master_site.*","users_sites.id as id2")
		->where("users.email",$user)
		->get();
		$no = 0;
		$html = "<table class='table'>
		<thead>
		<tr>
			<th>Site ID</th>
			<th>Site Name</th>
			<th>Action</th>
		</tr>
		</head><tbody>";

		foreach($rs as $data){
			$no++;
			$html .="<tr><td>".$data->siteid."</td><td>".$data->sitename."</td>
			<td><button class='btn btn-danger btn-xs' onclick=\"delSite('".$user."',".$data->id2.")\">Hapus</button></td></tr>";
		}
		$html .= "</tbody></table><p>Total $no site</p>";
		//$rsite = DB::table("users_sites")->where("userid",$user)->select("siteid")->get();
		//echo $rsite;
		//$site = DB::table("master_site")->whereNotIn("siteid",$rsite)->get();
		$site = DB::select(DB::RAW("select * from master_site where siteid not in (select siteid from users_sites where userid = '$user')"));
		
		$form = "<p align='right'><form class='form-inline' id='frmaddsite'>
			<input type='hidden' name='email' value='".$user."'>
			<select name='siteid' class='form-control'>";
		foreach($site as $s){
			$form .= "<option value='".$s->siteid."'>".$s->siteid." - ".$s->sitename."</option>";
		}
		$form .= "</select><button type='button' class='btn btn-primary' onclick=\"addSite('".$user."')\">Tambah</button></form></p>";
		return $form.$html;
		
	}

	function addsite(Request $r){
		$rs = DB::table("users_sites")->insert(["userid"=>$r->email,"siteid"=>$r->siteid]);
		if($rs){
			return "OK";
		}
		return "FAILED";
	}

	function deletesite(Request $r){
		$rs = DB::table("users_sites")->where(["id"=>$r->id])->delete();
		if($rs){
			return "OK";
		}
		return "FAILED";
	}

	function log_login(Request $r){
		$rs = DB::table("log_login")->where("userid",$r->userid)->orderBy("login_date","desc")->get();
		$html = "<table class='table table-bordered table-hover'>
		<tr>
			<td>Waktu Login</td>
		</tr>
		";
		foreach($rs as $data){
			$html .= "<tr><td>".$data->login_date."</td></tr>";
		}
		$html ."</table>";
		
		return $html;
	}
}
