<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Validator;

class DeviceController extends Controller
{
    function index(){
		$title ="Devices";
		$data = DB::table("master_device")
		->leftJoin("master_site","master_site.siteid","=","master_device.site_id")
		->select("master_device.*","master_site.sitename")
		->get();
		
		return view('konfigurasi/devices/index', compact('data','title'));
	}
	
		
	function devices_add(){
		$title  = "Tambah Data Perangkat";
		$site_id = DB::table("master_site")->get();
		return view('konfigurasi/devices/add', compact('title','site_id'));
		
	}
	function devices_simpan(Request $r){
		 $validator = Validator::make($r->all(), [
            'device_id' => 'required|max:255',
			'site_id' => 'required|max:255',
        ]);
		
		if ($validator->fails()) {
            return redirect('konfigurasi/devices/add')
                        ->withErrors($validator)
                        ->withInput();
        }
		
		if($this->cekdata($r->site_id,$r->device_id) > 0){
			return redirect('konfigurasi/devices/add')->with('warning','ID device sudah digunakan!')->withInput();
		}
		
		
		DB::table('master_device')->insert([
			'site_id' => $r->site_id,
			'device_id' => $r->device_id,
			]);
			
		return redirect('konfigurasi/devices')->with('success','Data berhasil disimpan');
	}
	
	
	private function cekdata($siteid,$deviceid){
		$rs = DB::table("master_device")
		->where("site_id",$siteid)
		->where("device_id",$deviceid)
		->count();
		
		return $rs;
	}
	
	function devices_edit($id){
		$title  = "Edit Data Device";
		
		$data = DB::table("master_device")->where("id",$id)->first();
		return view('konfigurasi/devices/edit', compact('data','title'));
		
	}
	
	function devices_update(Request $r){
		$validator = Validator::make($r->all(), [
            'site_id' => 'required|max:255',
			'device_id' => 'required|max:255',
        ]);
		if ($validator->fails()) {
            return redirect('konfigurasi/devices/add')
                        ->withErrors($validator)
                        ->withInput();
        }
		DB::table('master_device')
		->where("id",$r->id)
		->update([
			//'site_id' => $r->site_id,
			'device_id' => $r->device_id,
			]);
			
		return redirect('konfigurasi/devices')->with(['success' => 'Data berhasil disimpan']);
		
	}
	
	function devices_remove(Request $r){
		DB::table('master_device')
		->where("id",$r->id)
		->delete();
	}
}
