<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Auth;

class LaporanController extends Controller
{
    public function transaksi_harian(){
		$title= "Laporan Transaksi Harian";
		if(Auth::user()->akses == "SUPERUSER"){
			$sites = DB::table("master_site")->get();
		}
		else{
			$sites = DB::select(DB::RAW("select * from master_site where siteid in 
			(select siteid from users_sites	where userid = '".Auth::user()->email."')"));
		}
		return view("laporan.transaksi_harian",compact('title','sites'));
	}
	
	public function transaksi_harian_data(Request $r){
		$tgl1 = $r->tanggal1;
		$tgl2 = $r->tanggal2;
		
		$data = DB::table("parking_out_mobile")
		->whereBetween('datetimeout', [$tgl1." 00:00:00",$tgl2." 23:59:59"])
		->where('site_id', '=',  $r->siteid)
		->where("flag", 'LIKE', Auth::user()->akses == "SUPERUSER" ? '%': '0')
		->get();
		//dd($data);
		$qty = 0;
		$total = 0;
		$html = "";
		$html .= '<table class="table table-condensed table-bordered table-sm">
			<thead>
				<tr>
					<th>No Tiket</th>
					<th>Waktu Masuk</th>
					<th>Waktu Keluar</th>
					<th>Paket</th>
					<th>No Polisi</th>
					<th>Biaya Parkir</th>
					<th>Petugas</th>
				</tr>
				</thead>
				<tbody>';
				foreach($data as $d){
					$html .='<tr>
					<td>'.$d->qrcode.'</td>
					<td>'.date_format(date_create($d->datetimein),'d-M-Y H:i:s').'</td>
					<td>'.date_format(date_create($d->datetimeout),'d-M-Y H:i:s').'</td>
					<td>'.$d->vehicle.'</td>
					<td>'.$d->policeno.'</td>
					<td align="right">'.number_format($d->parking_fee).'</td>';
					
					$html .= '<td>'.$d->userout.'</td>
					</tr>';
					$total += $d->parking_fee;
					
					$qty++;
				}
		$html .= '</tbody></table>';
		$html .= '<p>Total Qty: '.$qty.'<br>';
		$html .= 'Total Amount: '.number_format($total).'</p>';
		return $html;
	}
	
	public function transaksi_bulanan(){
		$title= "Laporan Transaksi Bulanan";
		
		if(Auth::user()->akses == "SUPERUSER"){
			$sites = DB::table("master_site")->get();
		}
		else{
			$sites = DB::select(DB::RAW("select * from master_site where siteid in 
			(select siteid from users_sites	where userid = '".Auth::user()->email."')"));
		}
		return view("laporan.transaksi_bulanan",compact('title','sites'));
	}
	
	public function transaksi_bulanan_data(Request $r){
		$tgl1 = $r->tanggal1;
		$tgl2 = $r->tanggal2;
		$site_id = $r->siteid;
		
		$data = DB::table("parking_out_mobile")
		->whereRAW("left(datetimeout,7) >= '$tgl1' and left(datetimeout,7) <='$tgl2'")
		->where('site_id', '=',  $site_id)
		->where("flag", 'LIKE', Auth::user()->akses == "SUPERUSER" ? '%': '0')
		->selectRAW("left(datetimeout,7) as bulan, sum(parking_fee) as parking_fee")
		->groupBy(DB::RAW("left(datetimeout,7)"))
		->get();
		//dd($data);
		$total = 0;
		$html = "";
		$html .= '<table class="table table-condensed table-bordered table-sm">
			<thead>
				<tr>
					<th>Bulan</th>
					<th>Nominal</th>
				</tr>
				</thead>
				<tbody>';
				foreach($data as $d){
					$html .='<tr>
					<td>'.$d->bulan.'</td>
					<td align="right">'.number_format($d->parking_fee).'</td>
					</tr>';
					$total += $d->parking_fee;
					
				}
		$html .= '</tbody></table>';
		$html .= 'Total Amount: '.number_format($total).'</p>';
		return $html;
	}
}
