<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Auth;
use Validator;

class SiteController extends Controller
{
    function lokasi(){
		$title  = "Data Lokasi";
		$data = DB::table("master_site")->get();
		return view('konfigurasi/lokasi/index', compact('data','title'));
		
	}
	function lokasi_add(){
		$title  = "Tambah Data Lokasi";
		
		return view('konfigurasi/lokasi/add', compact('title'));
		
	}
	function lokasi_simpan(Request $r){
		$validator = Validator::make($r->all(), [
            'siteid' => 'required|max:255|unique:master_site',
			'sitename' => 'required|max:255',
			'rpt_parameter' => 'required|max:255'
        ]);
		if ($validator->fails()) {
            return redirect('konfigurasi/lokasi/add')
                        ->withErrors($validator)
                        ->withInput();
        }
		DB::table('master_site')->insert([
			'siteid' => $r->siteid,
			'sitename' => $r->sitename,
			'rpt_parameter' => $r->rpt_parameter,
			'exit_other_area' => $r->exit_other_area,
			]);
			
		return redirect('konfigurasi/lokasi')->with(['success' => 'Data berhasil disimpan']);;
	}
	
	function lokasi_edit($id){
		$title  = "Edit Data Lokasi";
		
		$data = DB::table("master_site")->where("siteid",$id)->first();
		return view('konfigurasi/lokasi/edit', compact('data','title'));
		
	}
	
	function lokasi_update(Request $r){
		
		$validator = Validator::make($r->all(), [
            'siteid' => 'required|max:255',
			'sitename' => 'required|max:255',
			'rpt_parameter' => 'required|max:255'
        ]);
		if ($validator->fails()) {
            return redirect('konfigurasi/lokasi/edit/'.$r->siteid)
                        ->withErrors($validator)
                        ->withInput();
        }
		
		DB::table('master_site')
		->where("siteid",$r->siteid)
		->update([
			'sitename' => $r->sitename,
			'rpt_parameter' => $r->rpt_parameter,
			'exit_other_area' => $r->exit_other_area,
			]);
		//Alert::success('success', 'Data updated!');
		return redirect('konfigurasi/lokasi')->with('success', 'Data updated!');
	}
}
