<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Auth;

class TransaksiController extends Controller
{
    public function shift_info()
	{
		$site_id = \SiteHelp::getDefaultSite(Auth::user()->akses,Auth::user()->email);
		$title  = "Shift Info";
		
		$data = DB::select("SELECT master_user.userid as userout, master_user.fullname, master_user.site_id, `parking_out_mobile`.`shift_id`,
		`parking_out_mobile`.`device_id`, `master_user`.`startshift`, 
		SUM(parking_out_mobile.parking_fee+parking_out_mobile.lt_fee) AS income, 
		CONCAT(TIMESTAMPDIFF(HOUR,master_user.startshift,NOW()), ' jam') AS durasi 
		FROM `master_user`  LEFT OUTER JOIN `parking_out_mobile` ON `parking_out_mobile`.`userout` = `master_user`.`userid` 
		WHERE `master_user`.`ustatus` = 'S' AND `master_user`.`shift_id` = parking_out_mobile.shift_id 
		and master_user.site_id = '" . $site_id . "' 
		GROUP BY master_user.userid, master_user.fullname, master_user.site_id, `parking_out_mobile`.`device_id`, 
		`parking_out_mobile`.`shift_id`, `master_user`.`startshift`");
		$data = DB::select("SELECT master_user.userid as userout, master_user.fullname, master_user.site_id, `parking_out_mobile`.`shift_id`,
		`parking_out_mobile`.`device_id`, `master_user`.`startshift`, 
		SUM(parking_out_mobile.parking_fee+parking_out_mobile.lt_fee) AS income, 
		CONCAT(TIMESTAMPDIFF(HOUR,master_user.startshift,NOW()), ' jam') AS durasi 
		FROM `master_user`  LEFT OUTER JOIN `parking_out_mobile` ON `parking_out_mobile`.`userout` = `master_user`.`userid` 
		WHERE `master_user`.`ustatus` = 'S' 
		
		GROUP BY master_user.userid, master_user.fullname, master_user.site_id, `parking_out_mobile`.`device_id`, 
		`parking_out_mobile`.`shift_id`, `master_user`.`startshift`");
		//dd($data);
		return view('transaksi.shift_info', compact('data', 'title'));
	}
	public function set_siteid(Request $r)
	{
		$site_id = $r->site_id;
		$r->session()->put('site_id', $site_id);
	}
	
	public function set_flag(Request $r)
	{
		DB::table("parking_out_mobile")
		->where("qrcode",$r->id)
		->update(["flag"=>1]);
		return "OK";
	}

	public function set_flag_in(Request $r)
	{
		DB::table("parking_in")
		->where("ti_qrcode",$r->id)
		->update(["flag"=>1]);
		return "OK";
	}
	
	public function batal(Request $r)
	{
		DB::table("parking_in")
		->where("ti_qrcode",$r->id)
		->update(["flag"=>9,"cancel_notes"=>$r->note]);
		return "OK";
	}
	
	public function undo_flag(Request $r)
	{
		$table = $r->table;
		if($table == "in"){
			DB::table("parking_in")
			->where("ti_qrcode",$r->id)
			->update(["flag"=>0]);
			return "OK";
		}
		else{
			DB::table("parking_out_mobile")
			->where("qrcode",$r->id)
			->update(["flag"=>0]);
			return "OK";
		}
		
	}

	public function vehicle_in(Request $request)
	{
		$title  = "Kendaraan Masuk";
		$search =  $request->input('q');
		
		if(Auth::user()->akses == "SUPERUSER"){
			$query = "parking_in.site_id <> '' ";
		}
		else{
			$query = "parking_in.site_id in (select siteid from users_sites where userid= '".Auth::user()->email."') "; 
		}
		if ($search != "") {
			$data = DB::table("parking_in")
				->leftJoin("master_site","master_site.siteid","=","parking_in.site_id")
				 ->leftJoin("master_lobby",function($join){
						$join->on("parking_in.lobby_id", "=", "master_lobby.id")
						->on("parking_in.site_id", "=", "master_lobby.site_id");

                })
				->where("parking_in.ti_policeno", 'like', '%' . $search . '%')
				->orWhere("parking_in.ti_qrcode", 'like', '%' . $search . '%')
				->orWhere("parking_in.site_id", '=',$search )
				->whereRAW($query)
				->select("parking_in.*", "master_lobby.lobby_name","master_site.sitename")
				->orderBy("parking_in.site_id", "asc")
				->orderBy("parking_in.ti_datetime", "desc")
				->paginate(10);
			$data->appends(['q' => $search]);
		} else {
			$data = DB::table("parking_in")
				->leftJoin("master_site","master_site.siteid","=","parking_in.site_id")
				 ->leftJoin("master_lobby",function($join){
						$join->on("parking_in.lobby_id", "=", "master_lobby.id")
						->on("parking_in.site_id", "=", "master_lobby.site_id");

                })
				->whereRAW($query)
				->select("parking_in.*", "master_lobby.lobby_name","master_site.sitename")
				->orderBy("parking_in.site_id", "asc")
				->orderBy("ti_datetime", "desc")
				->paginate(10);
		}
		if(Auth::user()->akses == "SUPERUSER"){
			$rekap = DB::table("parking_in")
				//->leftJoin("master_lobby", "parking_in.lobby_id", "=", "master_lobby.id")
				->leftJoin("master_site","master_site.siteid","=","parking_in.site_id")
				->select("master_site.siteid","master_site.sitename")
				//->whereRAW($query)
				->selectRaw('count(ti_key) as cnt')
				->groupBy("master_site.siteid","master_site.sitename")
				->get();
			
		}
		else{
			$rekap = DB::table("parking_in")
				//->leftJoin("master_lobby", "parking_in.lobby_id", "=", "master_lobby.id")
				->leftJoin("master_site","master_site.siteid","=","parking_in.site_id")
				->select("master_site.siteid","master_site.sitename")
				->whereRAW($query)
				->selectRaw('count(ti_key) as cnt')
				->groupBy("master_site.siteid","master_site.sitename")
				->where("flag","<>",1)->get();
		}
		
		$html = "";
		$a=array("warning","success","danger","primary","secondary");
		$random_keys=array_rand($a,5);
		$i = 0;
		foreach($rekap as $r){
			$i++;
			if($i == 5){
				$i = 0;
			}
			$html .= '
			
			  <div class="col-xl-3 col-lg-6 col-md-6 col-12">
			  <a href="?q='.$r->siteid.'">
				<div class="card bg-'.$a[$random_keys[$i]].'">
				  <div class="card-content">
					<div class="card-body pt-2 pb-0">
					  <div class="media">
						<div class="media-body white text-left">
						  <span>'.$r->sitename.'</span>
						  <h3 class="font-large-1 mb-0">'.number_format($r->cnt).'</h3>
						</div>
						
					  </div>';
					  if(Auth::user()->akses == "SUPERUSER"){
							$rekap_perlobby = DB::table("parking_in")
								->leftJoin("master_lobby", "parking_in.lobby_id", "=", "master_lobby.id")
								//->leftJoin("master_site","master_site.siteid","=","parking_in.site_id")
								->select("master_lobby.lobby_name")
								->selectRaw('count(ti_key) as cnt')
								->where("parking_in.site_id",$r->siteid)
								->groupBy("master_lobby.lobby_name")
								->get();
							
						}
						else{
							$rekap_perlobby = DB::table("parking_in")
								->leftJoin("master_lobby", "parking_in.lobby_id", "=", "master_lobby.id")
								//->leftJoin("master_site","master_site.siteid","=","parking_in.site_id")
								->select("master_lobby.lobby_name")
								->selectRaw('count(ti_key) as cnt')
								->groupBy("master_lobby.lobby_name")
								->where("parking_in.site_id",$r->siteid)
								->where("flag",0)->get();
								
						}
						foreach($rekap_perlobby as $r2){
									$html .= $r2->lobby_name.":".number_format($r2->cnt);
								}
					$html .= '</div>
					<br>
				  </div>
				</div></a>
			  </div>
			';
		}
		if(Auth::user()->akses == "SUPERUSER")
		{
			
			return view('transaksi.vehicle_in', compact('data', 'title','html'));
		}
		else{
			$html = "";
			return view('transaksi.vehicle_in_mgmt', compact('data', 'title','html'));
		}
	}
	
	public function vehicle_in_mgmt(Request $request)
	{
		$title  = "Kendaraan Masuk";
		$query = "parking_in.site_id in (select siteid from users_sites where userid= '".Auth::user()->email."') "; 
		$data = DB::table("parking_in")
				->leftJoin("master_site","master_site.siteid","=","parking_in.site_id")
				 ->leftJoin("master_lobby",function($join){
						$join->on("parking_in.lobby_id", "=", "master_lobby.id")
						->on("parking_in.site_id", "=", "master_lobby.site_id");

                })
				->whereRAW($query)
				->select("parking_in.*", "master_lobby.lobby_name","master_site.sitename")
				->orderBy("parking_in.site_id", "asc")
				->orderBy("parking_in.ti_datetime", "desc")
				->where("flag",0)->get();
		$html = "";
		foreach($data as $d){
			$html .= "<tr>
			<td>".$d->site_id." ".$d->sitename."</td>
			<td>".$d->ti_qrcode."</td>
			<td>".date_format(date_create($d->ti_datetime),'d-M-Y H:i:s')."</td>
			<td>".$d->ti_vehicle."</td>
			<td>".$d->ti_policeno."</td>
			<td>".$d->lobby_name."</td>
			<td>
			<a data-toggle=\"modal\" data-target=\".bd-example-modal-lg\" onclick=\"detail('".$d->site_id."','".$d->ti_qrcode."')\" class=\"btn btn-primary btn-xs\">Detil</a></td>
			</tr>";
			
		}
		return $html;
		
	}
	public function vehicle_in_detail(Request $request)
	{
		//$site_id = \SiteHelp::getDefaultSite(Auth::user()->akses,Auth::user()->email);
		$data = DB::table("parking_in")
			->leftJoin("master_lobby", "parking_in.lobby_id", "=", "master_lobby.id")
			//->where("parking_in.site_id", $site_id)
			//->where("master_lobby.site_id", $site_id)
			->where("parking_in.ti_qrcode", $request->id)
			->select("parking_in.*", "master_lobby.lobby_name")
			->first();
		return json_encode($data);
	}

	public function vehicle_out_detail(Request $request)
	{
		//$site_id = \SiteHelp::getDefaultSite(Auth::user()->akses,Auth::user()->email);
		$data = DB::table("parking_out_mobile")
			->leftJoin("master_lobby", "parking_out_mobile.gateout", "=", "master_lobby.id")
			//->where("parking_out_mobile.site_id", $site_id)
			//->where("master_lobby.site_id", $site_id)
			->where("parking_out_mobile.qrcode", $request->id)
			->select("parking_out_mobile.*", "master_lobby.lobby_name")
			->first();
		return json_encode($data);
	}

	public function set_carcall(Request $request)
	{
		$data = DB::table("parking_in")
			->where("site_id", $request->kdsite)
			->where("ti_qrcode", $request->id)
			->count();

		if ($data > 0) {
			$data = DB::table("parking_in")
				->where("site_id", $request->kdsite)
				->where("ti_qrcode", $request->id)
				->update(["car_call" => 'Y']);
			return "OK";
		} else {
			return "Call tidak dapat dilakukan!\r\nKendaraan sudah keluar dari area parkir";
		}
	}

	public function vehicle_out(Request $request)
	{
		//$site_id = \SiteHelp::getDefaultSite(Auth::user()->akses,Auth::user()->email);
		$title  = "Kendaraan Keluar";
		$search =  $request->input('q');
		if(Auth::user()->akses == "SUPERUSER"){
			$query = "parking_out_mobile.site_id <> '' ";
		}
		else{
			$query = "parking_out_mobile.site_id in (select siteid from users_sites where userid= '".Auth::user()->email."') "; 
		}
		if ($search != "") {
			$data = DB::table("parking_out_mobile")
				->leftJoin("master_site","master_site.siteid","=","parking_out_mobile.site_id")
				->where("policeno", 'like', '%' . $search . '%')
				->where("flag", 'LIKE', Auth::user()->akses == "SUPERUSER" ? '%': '0')
				->whereRAW($query)
				->select("parking_out_mobile.*","master_site.sitename")
				->orderBy("datetimeout", "desc")
				->paginate(10);
			$data->appends(['q' => $search]);
		} else {
			$data = DB::table("parking_out_mobile")
				->leftJoin("master_site","master_site.siteid","=","parking_out_mobile.site_id")
				->where("policeno", 'like', '%' . $search . '%')
				->where("flag", 'LIKE', Auth::user()->akses == "SUPERUSER" ? '%': '0')
				->whereRAW($query)
				->select("parking_out_mobile.*","master_site.sitename")
				->orderBy("datetimeout", "desc")
				->paginate(10);
		}
		if(Auth::user()->akses == "SUPERUSER")
		{
			
			return view('transaksi.vehicle_out', compact('data', 'title'));
		}
		else{
			$html = "";
			return view('transaksi.vehicle_out_mgmt', compact('data', 'title'));
		}
		
		
	}
	public function vehicle_out_mgmt(Request $request)
	{
		$title  = "Kendaraan Keluar";
		$search =  $request->input('q');
		//$query = "master_site.sitename like '%$search%' or parking_out_mobile.policeno like '%$search%'"; 
		$query = "parking_out_mobile.site_id in (select siteid from users_sites where userid= '".Auth::user()->email."') "; 
		if($search == ""){
			$data = DB::table("parking_out_mobile")
			->leftJoin("master_site","master_site.siteid","=","parking_out_mobile.site_id")
			//->orWhere("policeno", 'like', '%' . $search . '%')
			//->orWhere("master_site.sitename", 'like', '%' . $search . '%')
			->where("flag", 0)
			->whereRAW($query)
			->select("parking_out_mobile.*","master_site.sitename")
			->orderBy("datetimeout", "desc")
			->get();
		}
		else{
			$data = DB::table("parking_out_mobile")
			->leftJoin("master_site","master_site.siteid","=","parking_out_mobile.site_id")
			->orWhere("policeno", 'like', '%' . $search . '%')
			->orWhere("master_site.sitename", 'like', '%' . $search . '%')
			->where("flag", 0)
			->whereRAW($query)
			->select("parking_out_mobile.*","master_site.sitename")
			->orderBy("datetimeout", "desc")
			->get();
		}
		
		
		$html = "";
		foreach($data as $d){
			$html .= "<tr>
						<td nowrap>".$d->site_id." ".$d->sitename."</td>
						<td>".$d->qrcode."</td>
						<td nowrap>".date_format(date_create($d->datetimein),'d-M-Y H:i')."</td>
						<td nowrap>".date_format(date_create($d->datetimeout),'d-M-Y H:i')."</td>
						<td>".$d->vehicle."</td>
						<td>".$d->policeno."</td>
						<td>". number_format($d->parking_fee)."</td>
						<td>".$d->userout."</td>
					
					</td>
						@endif
						<td><a data-toggle=\"modal\" data-target=\".bd-example-modal-lg\" onclick=\"detail('".$d->site_id."','".$d->qrcode."')\" class=\"btn btn-primary btn-xs\">Detil</a></td>
						
						
					</tr>";
		}
		return $html;
		
	}
	public function hapus_item(Request $r)
	{
		$table = $r->table;
		$id = $r->id;
		DB::table($table)->where("id", $id)->delete();
		return  "OK";
			
		/*	
		if ($table == "master_user") {
			$rs = DB::table("master_user")
				->where("id", $id)
				->first();
			if ($rs->ustatus == "S") {
				return "User tidak dapat dihapus karena sedang aktif!";
			}
			DB::table($table)
				->where("id", $id)->delete();
			return  "OK";
		} else {
			DB::table($table)->where("id", $id)->delete();
			return  "OK";
		}
		*/
	}

	public function endshift(Request $r)
	{
		$userid = $r->userid;
		$shiftid = $r->shiftid;

		$rs = DB::table("master_user")
			->where("shift_id", $shiftid)
			->where("userid", $userid)
			->update(["ustatus" => "E"]);
		return  "OK";
	}
	
	
}
