<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Validator;

class UsersController extends Controller
{
    function index(){
		$title ="Users";
		$data = DB::table("master_user")
		->leftJoin("master_site","master_site.siteid","=","master_user.site_id")
		->select("master_site.sitename","master_user.*")
		->get();
		
		return view('konfigurasi/users/index', compact('data','title'));
	}
	
		
	function users_add(){
		$title  = "Tambah Data User";
		
		$site_id = DB::table("master_site")->get();
		return view('konfigurasi/users/add', compact('title','site_id'));
		
	}
	function users_simpan(Request $r){
		 $validator = Validator::make($r->all(), [
            'userid' => 'required|max:255',
			'fullname' => 'required|max:255',
        ]);
		
		if ($validator->fails()) {
            return redirect('konfigurasi/users/add')
                        ->withErrors($validator)
                        ->withInput();
        }
		
		if($this->cekuser($r->siteid,$r->userid) > 0){
			
			return redirect('konfigurasi/users/add')->with(['success'=>'ID User sudah digunakan!']);
			
		}
		
		
		DB::table('master_user')->insert([
			'site_id' => $r->siteid,
			'userid' => $r->userid,
			'fullname' => $r->fullname,
			'akses' => "DRIVER",
			'pwd' => md5('1234'),
			]);
			
		return redirect('konfigurasi/users')->with('success','Data berhasil disimpan');
	}
	
	
	private function cekuser($siteid,$userid){
		$rs = DB::table("master_user")
		->where("site_id",$siteid)
		->where("userid",$userid)
		->count();
		
		return $rs;
	}
	
	function users_edit($id){
		$title  = "Edit Data Petugas Valet";
		$data = DB::table("master_user")->where("id",$id)->first();
		return view('konfigurasi/users/edit', compact('data','title'));
		
	}
	
	function users_update(Request $r){
		$validator = Validator::make($r->all(), [
            'userid' => 'required|max:255',
			'fullname' => 'required|max:255'
        ]);
		if ($validator->fails()) {
            return redirect('konfigurasi/users/update')
                        ->withErrors($validator)
                        ->withInput();
        }
		DB::table('master_user')
		->where("id",$r->id)
		->update([
			'userid' => $r->siteid,
			'fullname' => $r->fullname
			]);
			
		return redirect('konfigurasi/users')->with(['success' => 'Data berhasil disimpan']);;
	}

	function sitelist(Request $r){
		$user = $r->userid;
		$rs = DB::table("master_user_sites")
		->leftJoin("master_user","master_user.userid","=","master_user_sites.userid")
		->leftJoin("master_site","master_user_sites.siteid","=","master_site.siteid")
		->select("master_site.*","master_user_sites.id as id2")
		->where("master_user.userid",$user)
		->get();
		$no = 0;
		$html = "<table class='table'>
		<thead>
		<tr>
			<th>Site ID</th>
			<th>Site Name</th>
			<th>Action</th>
		</tr>
		</head><tbody>";

		foreach($rs as $data){
			$no++;
			$html .="<tr><td>".$data->siteid."</td><td>".$data->sitename."</td>
			<td><button class='btn btn-danger btn-xs' onclick=\"hapus('master_user_sites',".$data->id2.")\">Hapus</button></td></tr>";
		}
		$html .= "</tbody></table><p>Total $no site</p>";
		//$rsite = DB::table("master_user_sites")->where("userid",$user)->select("siteid")->get();
		//echo $rsite;
		//$site = DB::table("master_site")->whereNotIn("siteid",$rsite)->get();
		$site = DB::select(DB::RAW("select * from master_site where siteid not in (select siteid from master_user_sites where userid = '$user')"));
		
		$form = "<p align='right'><form class='form-inline' id='frmaddsite'>
			<input type='hidden' name='userid' value='".$user."'>
			<select name='siteid' class='form-control'>";
		foreach($site as $s){
			$form .= "<option value='".$s->siteid."'>".$s->siteid." - ".$s->sitename."</option>";
		}
		$form .= "</select><button type='button' class='btn btn-primary' onclick=\"addSite('".$user."')\">Tambah</button></form></p>";
		return $form.$html;
		
	}

	function addsite(Request $r){
		$rs = DB::table("master_user_sites")->insert(["userid"=>$r->userid,"siteid"=>$r->siteid]);
		if($rs){
			return "OK";
		}
		return "FAILED";
	}

	function log_login(Request $r){
		$rs = DB::table("log_login")->where("userid",$r->userid)->orderBy("login_date","desc")->get();
		$html = "<table class='table table-bordered table-hover'>
		<tr>
			<td>Waktu Login</td>
		</tr>
		";
		foreach($rs as $data){
			$html .= "<tr><td>".$data->login_date."</td></tr>";
		}
		$html ."</table>";
		
		return $html;
	}
}
