@extends('layouts.app')

@section('content')
				<a class="btn btn-primary btn-sm" href="{{url('konfigurasi/admin/add')}}">Tambah</a>						
				@include('layouts/flash-messages')							
				<table class="table">
												<thead>
													<tr>
														<th>ID</th>
														<th>Nama</th>
														<th>Email</th>
														<th>Akses</th>
														<th>Lokasi</th>
														<th>Action</th>
														
														
													</tr>
												</thead>
												<tbody>
													@foreach($data as $d)
													<tr>
														<td>{{ $d->username }}</td>
														<td>{{ $d->fullname }}</td>
														<td>{{ $d->email }}</td>
														<td>{{ $d->akses }}</td>
														<td>
														<ol style="padding:0">
														<?php
														$no = 0;
														$rs = DB::table("users_sites")
														->leftJoin("users","users.email","=","users_sites.userid")
														->leftJoin("master_site","users_sites.siteid","=","master_site.siteid")
														->select("master_site.*","users_sites.id as id2")
														->where("users.email",$d->email)
														->get();
														foreach($rs as $data){
															
															echo "<li>".$data->siteid." - ".$data->sitename."</li>";
														}
														?>
														</ol>
														</td>
														
														<td><button class="btn btn-primary btn-xs" onclick="akses('{{$d->email}}')" data-toggle="modal" data-target=".bd-akses-modal-lg">Akses Lokasi</button>
														<button class="btn btn-info btn-xs" onclick="logLogin('{{$d->email}}')" data-toggle="modal" data-target=".bd-loginhist-modal-lg">History Login</button>
														<button class="btn btn-danger btn-xs" onclick="hapus('users',{{$d->id}})">Hapus</button></td>
														
													</tr>
													@endforeach
												</tbody>
											</table>
@endsection	
@section("jsfunction")
<script>
	function akses(userid){
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
				}
			});
			$.ajax({
				type : "POST",
				url  : "{{url('konfigurasi/admin/sitelist')}}",
				data : {userid:userid},
				beforeSend: function() {
						$("#div_sitelist").html("<p>Please wait..</p>");
				},
				success: function(data){
					$("#div_sitelist").html(data);
				}
			});
	}

	function addSite(userid){
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
				}
			});
			$.ajax({
				type : "POST",
				url  : "{{url('konfigurasi/admin/addsiteuser')}}",
				data : $("#frmaddsite").serialize(),
				beforeSend: function() {
						$("#div_sitelist").html("<p>Please wait..</p>");
				},
				success: function(data){
					//$("#div_sitelist").html(data);
					akses(userid);
				}
			});
	}

	function delSite(email,id){
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
				}
			});
			$.ajax({
				type : "POST",
				url  : "{{url('konfigurasi/admin/deleteusersite')}}",
				data : {id:id},
				beforeSend: function() {
						$("#div_sitelist").html("<p>Please wait..</p>");
				},
				success: function(data){
					//$("#div_sitelist").html(data);
					akses(email);
				}
			});
	}

	function logLogin(userid){
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
				}
			});
			$.ajax({
				type : "POST",
				url  : "{{url('konfigurasi/admin/log_login')}}",
				data : {userid:userid},
				beforeSend: function() {
						$("#div_loglogin").html("<p>Please wait..</p>");
				},
				success: function(data){
					$("#div_loglogin").html(data);
					//akses(userid);
				}
			});
	}


	</script>
@endsection
<!-- akses lokasi -->

<div class="modal fade bd-akses-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Akses Lokasi</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div id="div_sitelist"></div>
            </div>
            <div class="modal-footer">
                <a href="" type="button" class="btn btn-secondary">Close</a>
            </div>
        </div>
    </div>
</div>


<!-- History Login --> 
<div class="modal fade bd-loginhist-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">History Login</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
				<div id="div_loglogin"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>